"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RulesSettingsLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _rules_settings_flyout = require("./rules_settings_flyout");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesSettingsLink = ({
  alertDeleteCategoryIds
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const {
    application: {
      capabilities: {
        rulesSettings = {}
      }
    }
  } = (0, _kibana.useKibana)().services;
  const {
    show,
    readFlappingSettingsUI,
    readQueryDelaySettingsUI
  } = rulesSettings;
  if (!show || !readFlappingSettingsUI && !readQueryDelaySettingsUI) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsVisible(true),
    iconType: "gear",
    "data-test-subj": "rulesSettingsLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.link.title",
    defaultMessage: "Settings"
  })), /*#__PURE__*/_react.default.createElement(_rules_settings_flyout.RulesSettingsFlyout, {
    isVisible: isVisible,
    onClose: () => setIsVisible(false),
    alertDeleteCategoryIds: alertDeleteCategoryIds
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RulesSettingsLink = RulesSettingsLink;