"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCollector = registerCollector;
var _alerts = require("../../common/utils/alerts");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCollector(usageCollection, getAlertIndex) {
  const collector = usageCollection.makeUsageCollector({
    type: 'transform',
    schema: {
      alertRules: {
        transform_health: {
          count_by_check_type: {
            notStarted: {
              type: 'long',
              _meta: {
                description: 'total number of alerting rules performing the not started health check'
              }
            },
            errorMessages: {
              type: 'long',
              _meta: {
                description: 'total number of alerting rules performing the error message health check'
              }
            },
            healthCheck: {
              type: 'long',
              _meta: {
                description: 'total number of alerting rules performing the health check with the stats API'
              }
            }
          }
        }
      }
    },
    isReady: () => true,
    fetch: async ({
      esClient
    }) => {
      const transformHealthRuleInstances = await esClient.search({
        index: await getAlertIndex(),
        size: 10000,
        query: {
          bool: {
            filter: [{
              term: {
                type: 'alert'
              }
            }, {
              term: {
                'alert.alertTypeId': _common.TRANSFORM_RULE_TYPE.TRANSFORM_HEALTH
              }
            }]
          }
        }
      }, {
        maxRetries: 0
      });
      const resultsByCheckType = transformHealthRuleInstances.hits.hits.reduce((acc, curr) => {
        var _resultConfig$notStar, _resultConfig$errorMe, _resultConfig$healthC;
        const doc = curr._source;
        if (!doc) return acc;
        const {
          alert: {
            params: {
              testsConfig
            }
          }
        } = doc;
        const resultConfig = (0, _alerts.getResultTestConfig)(testsConfig);
        acc.notStarted += resultConfig !== null && resultConfig !== void 0 && (_resultConfig$notStar = resultConfig.notStarted) !== null && _resultConfig$notStar !== void 0 && _resultConfig$notStar.enabled ? 1 : 0;
        acc.errorMessages += resultConfig !== null && resultConfig !== void 0 && (_resultConfig$errorMe = resultConfig.errorMessages) !== null && _resultConfig$errorMe !== void 0 && _resultConfig$errorMe.enabled ? 1 : 0;
        acc.healthCheck += resultConfig !== null && resultConfig !== void 0 && (_resultConfig$healthC = resultConfig.healthCheck) !== null && _resultConfig$healthC !== void 0 && _resultConfig$healthC.enabled ? 1 : 0;
        return acc;
      }, {
        notStarted: 0,
        errorMessages: 0,
        healthCheck: 0
      });
      return {
        alertRules: {
          [_common.TRANSFORM_RULE_TYPE.TRANSFORM_HEALTH]: {
            count_by_check_type: resultsByCheckType
          }
        }
      };
    }
  });
  usageCollection.registerCollector(collector);
}