"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docTitleService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _text = require("../text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DocTitleService {
  constructor() {
    (0, _defineProperty2.default)(this, "changeDocTitle", () => {});
  }
  init(changeDocTitle) {
    this.changeDocTitle = changeDocTitle;
  }
  setTitle(page) {
    if (!page || page === 'home') {
      this.changeDocTitle(`${_text.textService.breadcrumbs.home}`);
    } else if (_text.textService.breadcrumbs[page]) {
      this.changeDocTitle(`${_text.textService.breadcrumbs[page]} - ${_text.textService.breadcrumbs.home}`);
    }
  }
}
const docTitleService = exports.docTitleService = new DocTitleService();