"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowMessagesPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _serverless_context = require("../../../../serverless_context");
var _constants = require("../../../../../../common/constants");
var _job_icon = require("../../../../components/job_icon");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRowMessagesPane = ({
  transformId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    showNodeInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sorting, setSorting] = (0, _react.useState)({
    sort: {
      field: 'timestamp',
      direction: 'desc'
    }
  });
  const {
    isLoading,
    error,
    data = {
      messages: [],
      total: 0
    }
  } = (0, _hooks.useGetTransformAuditMessages)(transformId, sorting.sort.field, sorting.sort.direction);
  const {
    messages,
    total
  } = data;
  const errorMessage = error !== null ? _i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.errorMessage', {
    defaultMessage: 'Messages could not be loaded'
  }) : '';
  const refreshTransformList = (0, _hooks.useRefreshTransformList)();
  const columns = [{
    name: refreshTransformList ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.transform.transformList.refreshLabel', {
        defaultMessage: 'Refresh'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon
    // TODO: Replace this with ML's blurButtonOnClick when it's moved to a shared package
    , {
      onClick: e => {
        e.currentTarget.blur();
        refreshTransformList();
      },
      iconType: "refresh",
      "aria-label": _i18n.i18n.translate('xpack.transform.transformList.refreshAriaLabel', {
        defaultMessage: 'Refresh'
      })
    })) : '',
    render: message => /*#__PURE__*/_react.default.createElement("div", {
      css: {
        margin: 'auto'
      }
    }, /*#__PURE__*/_react.default.createElement(_job_icon.JobIcon, {
      message: message
    })),
    width: euiTheme.size.xl
  }, {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.timeLabel', {
      defaultMessage: 'Time'
    }),
    render: timestamp => (0, _eui.formatDate)(timestamp, _constants.TIME_FORMAT),
    sortable: true
  }, ...(showNodeInfo ? [{
    field: 'node_name',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.nodeLabel', {
      defaultMessage: 'Node'
    }),
    sortable: true
  }] : []), {
    field: 'message',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.messageLabel', {
      defaultMessage: 'Message'
    }),
    width: showNodeInfo ? '50%' : '70%'
  }];
  const getPageOfMessages = ({
    index,
    size
  }) => {
    let list = messages;
    if (total <= _constants.DEFAULT_MAX_AUDIT_MESSAGE_SIZE) {
      var _sorting$sort$field;
      const sortField = (_sorting$sort$field = sorting.sort.field) !== null && _sorting$sort$field !== void 0 ? _sorting$sort$field : 'timestamp';
      list = messages.sort((a, b) => {
        const prev = a[sortField];
        const curr = b[sortField];
        return sorting.sort.direction === 'asc' ? prev - curr : curr - prev;
      });
    }
    const listLength = list.length;
    const pageStart = index * size;
    return {
      pageOfMessages: list.slice(pageStart, pageStart + size),
      totalItemCount: listLength
    };
  };
  const onChange = ({
    page = {
      index: 0,
      size: 10
    },
    sort
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index);
    setPageSize(size);
    if (sort) {
      setSorting({
        sort
      });
    }
  };
  const {
    pageOfMessages,
    totalItemCount
  } = getPageOfMessages({
    index: pageIndex,
    size: pageSize
  });
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [10, 20, 50],
    showPerPageOptions: true
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasBorder: false,
    paddingSize: "s",
    "data-test-subj": "transformMessagesTabContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "transform__TransformTable__messagesPaneTable",
    items: pageOfMessages,
    columns: columns,
    compressed: true,
    loading: isLoading,
    error: errorMessage,
    pagination: pagination,
    onChange: onChange,
    sorting: sorting
  }));
};
exports.ExpandedRowMessagesPane = ExpandedRowMessagesPane;