"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DanglingTasksWarning = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DanglingTasksWarning = ({
  transformIdsWithoutConfig
}) => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const deleteTransforms = (0, _hooks.useDeleteTransforms)();
  const closeModal = () => setIsModalVisible(false);
  const openModal = () => setIsModalVisible(true);
  const confirmDelete = () => {
    if (transformIdsWithoutConfig) {
      deleteTransforms(
      // If transform task doesn't have any corresponding config
      // we won't know what the destination index or data view would be
      // and should be force deleted
      {
        transformsInfo: transformIdsWithoutConfig.map(id => ({
          id,
          state: _constants.TRANSFORM_STATE.FAILED
        })),
        deleteDestIndex: false,
        deleteDestDataView: false,
        forceDelete: true
      });
    }
    closeModal();
  };
  if (!transformIdsWithoutConfig || transformIdsWithoutConfig.length === 0) {
    return null;
  }
  const isBulkAction = transformIdsWithoutConfig.length > 1;
  const bulkDeleteModalTitle = _i18n.i18n.translate('xpack.transform.transformList.bulkDeleteModalTitle', {
    defaultMessage: 'Delete {count} {count, plural, one {transform} other {transforms}}?',
    values: {
      count: transformIdsWithoutConfig.length
    }
  });
  const deleteModalTitle = _i18n.i18n.translate('xpack.transform.transformList.deleteModalTitle', {
    defaultMessage: 'Delete {transformId}?',
    values: {
      transformId: transformIdsWithoutConfig[0]
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.danglingTasksError",
    defaultMessage: "{count} {count, plural, one {transform is} other {transforms are}} missing configuration details: [{transformIds}] {count, plural, one {It} other {They}} cannot be recovered and should be deleted.",
    values: {
      count: transformIdsWithoutConfig.length,
      transformIds: transformIdsWithoutConfig.join(', ')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    size: "s",
    onClick: openModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.forceDeleteTransformMessage",
    defaultMessage: "Delete {count} {count, plural, one {transform} other {transforms}}",
    values: {
      count: transformIdsWithoutConfig.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: isBulkAction ? bulkDeleteModalTitle : deleteModalTitle,
    onCancel: closeModal,
    onConfirm: confirmDelete,
    cancelButtonText: _i18n.i18n.translate('xpack.transform.transformList.deleteModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.transform.transformList.deleteModalDeleteButton', {
      defaultMessage: 'Delete'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "danger"
  }));
};
exports.DanglingTasksWarning = DanglingTasksWarning;