"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reauthorizeActionNameText = exports.isReauthorizeActionDisabled = exports.ReauthorizeActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
var _reauthorization_utils = require("../../../../common/reauthorization_utils");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reauthorizeActionNameText = exports.reauthorizeActionNameText = _i18n.i18n.translate('xpack.transform.transformList.reauthorizeActionNameText', {
  defaultMessage: 'Reauthorize'
});
const isReauthorizeActionDisabled = (items, canStartStopTransform, transformNodes) => {
  return !canStartStopTransform || items.length === 0 || transformNodes === 0 || !items.some(_reauthorization_utils.needsReauthorization);
};
exports.isReauthorizeActionDisabled = isReauthorizeActionDisabled;
const ReauthorizeActionName = ({
  items,
  forceDisable,
  transformNodes
}) => {
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const someNeedsReauthorization = items.some(_reauthorization_utils.needsReauthorization);
  const actionIsDisabled = isReauthorizeActionDisabled(items, canStartStopTransform, transformNodes);
  let content;
  if (actionIsDisabled && items.length > 0) {
    if (!canStartStopTransform && someNeedsReauthorization) {
      content = (0, _create_capability_failure_message.createCapabilityFailureMessage)('canReauthorizeTransform');
    }
    if (!someNeedsReauthorization) {
      content = _i18n.i18n.translate('xpack.transform.transformList.reauthorizeBulkActionDisabledToolTipContent', {
        defaultMessage: 'One or more selected transforms must require reauthorization.'
      });
    }
  }
  const text = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, reauthorizeActionNameText);
  if ((forceDisable === true || actionIsDisabled) && content !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content
    }, text);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text);
};
exports.ReauthorizeActionName = ReauthorizeActionName;