"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _edit_action_name = require("./edit_action_name");
var _app_dependencies = require("../../../../app_dependencies");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEditAction = (forceDisable, transformNodes) => {
  const {
    data: dataViewsTitleIdMap
  } = (0, _hooks.useGetDataViewsTitleIdMap)();
  const {
    canCreateTransform
  } = (0, _hooks.useTransformCapabilities)();
  const [config, setConfig] = (0, _react.useState)();
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [dataViewId, setDataViewId] = (0, _react.useState)();
  const closeFlyout = () => setIsFlyoutVisible(false);
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const clickHandler = (0, _react.useCallback)(async item => {
    try {
      if (!dataViewsTitleIdMap) {
        return;
      }
      const dataViewTitle = Array.isArray(item.config.source.index) ? item.config.source.index.join(',') : item.config.source.index;
      const newDataViewId = dataViewsTitleIdMap[dataViewTitle];
      if (newDataViewId === undefined) {
        toastNotifications.addWarning(_i18n.i18n.translate('xpack.transform.edit.noDataViewErrorPromptText', {
          defaultMessage: 'Unable to get the data view for the transform {transformId}. No data view exists for {dataViewTitle}.',
          values: {
            dataViewTitle,
            transformId: item.id
          }
        }));
      } else {
        setDataViewId(newDataViewId);
      }
      setConfig(item.config);
      setIsFlyoutVisible(true);
    } catch (e) {
      toastNotifications.addError(e, {
        title: _i18n.i18n.translate('xpack.transform.edit.errorPromptText', {
          defaultMessage: 'An error occurred checking if source data view exists'
        })
      });
    }
  }, [dataViewsTitleIdMap, toastNotifications]);
  const action = (0, _react.useMemo)(() => ({
    name: () => /*#__PURE__*/_react.default.createElement(_edit_action_name.EditActionName, null),
    enabled: () => canCreateTransform && !forceDisable && transformNodes > 0,
    description: _edit_action_name.editActionNameText,
    icon: 'pencil',
    type: 'icon',
    onClick: item => clickHandler(item),
    'data-test-subj': 'transformActionEdit'
  }), [canCreateTransform, clickHandler, forceDisable, transformNodes]);
  return {
    action,
    config,
    closeFlyout,
    isFlyoutVisible,
    dataViewId
  };
};
exports.useEditAction = useEditAction;