"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformFunctionSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TransformFunctionSelector = ({
  selectedFunction,
  onChange
}) => {
  const transformFunctions = [{
    name: _constants.TRANSFORM_FUNCTION.PIVOT,
    helpText: _i18n.i18n.translate('xpack.transform.stepDefineForm.pivotHelperText', {
      defaultMessage: 'Aggregate and group your data.'
    }),
    icon: 'aggregate',
    title: _i18n.i18n.translate('xpack.transform.stepDefineForm.pivotLabel', {
      defaultMessage: 'Pivot'
    })
  }, {
    name: _constants.TRANSFORM_FUNCTION.LATEST,
    helpText: _i18n.i18n.translate('xpack.transform.stepDefineForm.latestHelperText', {
      defaultMessage: 'Keep track of your most recent data.'
    }),
    icon: 'clock',
    title: _i18n.i18n.translate('xpack.transform.stepDefineForm.latestLabel', {
      defaultMessage: 'Latest'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": "transformFunctionSelection"
  }, transformFunctions.map(({
    helpText,
    icon,
    name,
    title
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: name,
    style: {
      width: 320
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: icon
    }),
    title: title,
    description: helpText,
    "data-test-subj": `transformCreation-${name}-option${selectedFunction === name ? ' selectedFunction' : ''}`,
    selectable: {
      onClick: () => {
        // Only allow one function selected at a time and don't allow deselection
        if (selectedFunction === name) {
          return;
        }
        onChange(name);
      },
      isSelected: selectedFunction === name
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.TransformFunctionSelector = TransformFunctionSelector;