"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdvancedRuntimeMappingsEditor = void 0;
var _react = require("react");
var _public = require("@kbn/es-ui-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useXJsonMode
} = _public.XJson;
const useAdvancedRuntimeMappingsEditor = defaults => {
  const stringifiedRuntimeMappings = JSON.stringify(defaults.runtimeMappings, null, 2);

  // Advanced editor for source config state
  const [runtimeMappingsUpdated, setRuntimeMappingsUpdated] = (0, _react.useState)(defaults.runtimeMappingsUpdated);
  const [runtimeMappings, setRuntimeMappings] = (0, _react.useState)(defaults.runtimeMappings);
  const [isRuntimeMappingsEditorSwitchModalVisible, setRuntimeMappingsEditorSwitchModalVisible] = (0, _react.useState)(false);
  const [isRuntimeMappingsEditorEnabled, setRuntimeMappingsEditorEnabled] = (0, _react.useState)(defaults.isRuntimeMappingsEditorEnabled);
  const [isRuntimeMappingsEditorApplyButtonEnabled, setRuntimeMappingsEditorApplyButtonEnabled] = (0, _react.useState)(false);
  const [advancedEditorRuntimeMappingsLastApplied, setAdvancedEditorRuntimeMappingsLastApplied] = (0, _react.useState)(stringifiedRuntimeMappings);
  const {
    convertToJson,
    setXJson: setAdvancedRuntimeMappingsConfig,
    xJson: advancedRuntimeMappingsConfig
  } = useXJsonMode(stringifiedRuntimeMappings !== null && stringifiedRuntimeMappings !== void 0 ? stringifiedRuntimeMappings : '');
  const applyRuntimeMappingsEditorChanges = () => {
    const parsedRuntimeMappings = advancedRuntimeMappingsConfig === '' ? {} : JSON.parse(advancedRuntimeMappingsConfig);
    const prettySourceConfig = JSON.stringify(parsedRuntimeMappings, null, 2);
    setRuntimeMappingsUpdated(true);
    setRuntimeMappings(parsedRuntimeMappings);
    setAdvancedRuntimeMappingsConfig(prettySourceConfig);
    setAdvancedEditorRuntimeMappingsLastApplied(prettySourceConfig);
    setRuntimeMappingsEditorApplyButtonEnabled(false);
  };

  // If switching to KQL after updating via editor - reset search
  const toggleRuntimeMappingsEditor = (reset = false) => {
    if (reset === true) {
      setRuntimeMappingsUpdated(false);
      setAdvancedRuntimeMappingsConfig(advancedEditorRuntimeMappingsLastApplied);
    }
    setRuntimeMappingsEditorEnabled(!isRuntimeMappingsEditorEnabled);
    setRuntimeMappingsEditorApplyButtonEnabled(false);
  };
  return {
    actions: {
      applyRuntimeMappingsEditorChanges,
      setRuntimeMappingsEditorApplyButtonEnabled,
      setRuntimeMappingsEditorEnabled,
      setAdvancedEditorRuntimeMappingsLastApplied,
      setRuntimeMappingsEditorSwitchModalVisible,
      setRuntimeMappingsUpdated,
      toggleRuntimeMappingsEditor,
      convertToJson,
      setAdvancedRuntimeMappingsConfig
    },
    state: {
      advancedEditorRuntimeMappingsLastApplied,
      isRuntimeMappingsEditorApplyButtonEnabled,
      isRuntimeMappingsEditorEnabled,
      isRuntimeMappingsEditorSwitchModalVisible,
      runtimeMappingsUpdated,
      advancedRuntimeMappingsConfig,
      runtimeMappings
    }
  };
};
exports.useAdvancedRuntimeMappingsEditor = useAdvancedRuntimeMappingsEditor;