"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdvancedPivotEditor = void 0;
var _react = require("react");
var _public = require("@kbn/es-ui-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useXJsonMode
} = _public.XJson;
const useAdvancedPivotEditor = (defaults, previewRequest) => {
  const stringifiedPivotConfig = JSON.stringify(previewRequest.pivot, null, 2);

  // Advanced editor for pivot config state
  const [isAdvancedEditorSwitchModalVisible, setAdvancedEditorSwitchModalVisible] = (0, _react.useState)(false);
  const [isAdvancedPivotEditorApplyButtonEnabled, setAdvancedPivotEditorApplyButtonEnabled] = (0, _react.useState)(false);
  const [isAdvancedPivotEditorEnabled, setAdvancedPivotEditorEnabled] = (0, _react.useState)(defaults.isAdvancedPivotEditorEnabled);
  const [advancedEditorConfigLastApplied, setAdvancedEditorConfigLastApplied] = (0, _react.useState)(stringifiedPivotConfig);
  const {
    convertToJson,
    setXJson: setAdvancedEditorConfig,
    xJson: advancedEditorConfig
  } = useXJsonMode(stringifiedPivotConfig);
  (0, _react.useEffect)(() => {
    setAdvancedEditorConfig(stringifiedPivotConfig);
  }, [setAdvancedEditorConfig, stringifiedPivotConfig]);
  const toggleAdvancedEditor = () => {
    setAdvancedEditorConfig(advancedEditorConfig);
    setAdvancedPivotEditorEnabled(!isAdvancedPivotEditorEnabled);
    setAdvancedPivotEditorApplyButtonEnabled(false);
    if (isAdvancedPivotEditorEnabled === false) {
      setAdvancedEditorConfigLastApplied(advancedEditorConfig);
    }
  };
  return {
    actions: {
      convertToJson,
      setAdvancedEditorConfig,
      setAdvancedEditorConfigLastApplied,
      setAdvancedEditorSwitchModalVisible,
      setAdvancedPivotEditorApplyButtonEnabled,
      setAdvancedPivotEditorEnabled,
      toggleAdvancedEditor
    },
    state: {
      advancedEditorConfig,
      advancedEditorConfigLastApplied,
      isAdvancedEditorSwitchModalVisible,
      isAdvancedPivotEditorApplyButtonEnabled,
      isAdvancedPivotEditorEnabled
    }
  };
};
exports.useAdvancedPivotEditor = useAdvancedPivotEditor;