"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSettingsNumberOfRetriesValidator = void 0;
var _i18n = require("@kbn/i18n");
var _mlAggUtils = require("@kbn/ml-agg-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const numberOfRetriesInvalidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingsValidations.numberOfRetriesInvalidErrorMessage', {
  defaultMessage: 'Number of retries needs to be between 0 and 100, or -1 for infinite retries.'
});

// memoize validator
const validator = (0, _mlAggUtils.numberValidator)({
  min: -1,
  max: 100,
  integerOnly: true
});
const transformSettingsNumberOfRetriesValidator = value => validator(+value) === null ? [] : [numberOfRetriesInvalidErrorMessage];
exports.transformSettingsNumberOfRetriesValidator = transformSettingsNumberOfRetriesValidator;