"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformProgress = getTransformProgress;
exports.isCompletedBatchTransform = isCompletedBatchTransform;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTransformProgress(item) {
  var _item$stats, _item$stats$checkpoin, _item$stats$checkpoin2, _item$stats$checkpoin3;
  if (isCompletedBatchTransform(item)) {
    return 100;
  }
  const progress = item === null || item === void 0 ? void 0 : (_item$stats = item.stats) === null || _item$stats === void 0 ? void 0 : (_item$stats$checkpoin = _item$stats.checkpointing) === null || _item$stats$checkpoin === void 0 ? void 0 : (_item$stats$checkpoin2 = _item$stats$checkpoin.next) === null || _item$stats$checkpoin2 === void 0 ? void 0 : (_item$stats$checkpoin3 = _item$stats$checkpoin2.checkpoint_progress) === null || _item$stats$checkpoin3 === void 0 ? void 0 : _item$stats$checkpoin3.percent_complete;
  return progress !== undefined ? Math.round(progress) : undefined;
}
function isCompletedBatchTransform(item) {
  var _item$stats$checkpoin4;
  // If `checkpoint=1`, `sync` is missing from the config and state is stopped,
  // then this is a completed batch transform.
  return item.stats && item.config && ((_item$stats$checkpoin4 = item.stats.checkpointing) === null || _item$stats$checkpoin4 === void 0 ? void 0 : _item$stats$checkpoin4.last.checkpoint) === 1 && item.config.sync === undefined && item.stats.state === _constants.TRANSFORM_STATE.STOPPED;
}