"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformSelectorControl = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertToEuiOptions(values) {
  return values.map(v => ({
    value: v,
    label: v
  }));
}
const TransformSelectorControl = ({
  label,
  errors,
  onChange,
  selectedOptions,
  options,
  allowSelectAll = false
}) => {
  const [allowCustomOptions, setAllowCustomOptions] = (0, _react.useState)(false);
  const onSelectionChange = selectionUpdate => {
    if (!(selectionUpdate !== null && selectionUpdate !== void 0 && selectionUpdate.length)) {
      onChange([]);
      return;
    }
    if (selectionUpdate[selectionUpdate.length - 1].value === _constants.ALL_TRANSFORMS_SELECTION) {
      onChange([_constants.ALL_TRANSFORMS_SELECTION]);
      return;
    }
    onChange(selectionUpdate.slice(selectionUpdate[0].value === _constants.ALL_TRANSFORMS_SELECTION ? 1 : 0).map(v => v.value).filter(_mlIsDefined.isDefined));
  };
  const onCreateOption = allowCustomOptions ? searchValue => {
    onChange([...selectedOptions, searchValue]);
  } : undefined;
  const selectedOptionsEui = (0, _react.useMemo)(() => convertToEuiOptions(selectedOptions), [selectedOptions]);
  const optionsEui = (0, _react.useMemo)(() => {
    return convertToEuiOptions(allowSelectAll ? [_constants.ALL_TRANSFORMS_SELECTION, ...options] : options);
  }, [options, allowSelectAll]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: label,
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    error: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    onSearchChange: (searchValue, hasMatchingOption) => {
      setAllowCustomOptions(!hasMatchingOption && searchValue.includes('*'));
    },
    onCreateOption: onCreateOption,
    customOptionText: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.customOptionText', {
      defaultMessage: 'Include {searchValuePlaceholder} wildcard',
      values: {
        searchValuePlaceholder: '{searchValue}'
      }
    }),
    singleSelection: false,
    selectedOptions: selectedOptionsEui,
    options: optionsEui,
    onChange: onSelectionChange,
    fullWidth: true,
    "data-test-subj": 'transformSelection',
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length)
  }));
};
exports.TransformSelectorControl = TransformSelectorControl;