"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNoStatsTooltipMessage = createNoStatsTooltipMessage;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createNoStatsTooltipMessage({
  actionName,
  count = 1
}) {
  return _i18n.i18n.translate('xpack.transform.transformList.actionDisabledNoStatsTooltipMessage', {
    defaultMessage: '{actionName} is disabled because the status for {count, plural, one {this transform} other {some transforms}} is unavailable.',
    values: {
      actionName,
      count
    }
  });
}