"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTransformCapabilities = exports.getInitialTransformCapabilities = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialTransformCapabilities = (initialSetting = false) => ({
  canCreateTransform: initialSetting,
  canCreateTransformAlerts: initialSetting,
  canDeleteIndex: initialSetting,
  canDeleteTransform: initialSetting,
  canGetTransform: initialSetting,
  canPreviewTransform: initialSetting,
  canReauthorizeTransform: initialSetting,
  canResetTransform: initialSetting,
  canScheduleNowTransform: initialSetting,
  canStartStopTransform: initialSetting,
  canUseTransformAlerts: initialSetting
});
exports.getInitialTransformCapabilities = getInitialTransformCapabilities;
const isTransformCapabilities = arg => {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, Object.keys(getInitialTransformCapabilities())) && Object.values(arg).every(d => typeof d === 'boolean');
};
exports.isTransformCapabilities = isTransformCapabilities;