"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineReducer = exports.initialTimelineState = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _actions = require("./actions");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialTimelineState = exports.initialTimelineState = {
  timelineById: {}
};
const timelineReducer = exports.timelineReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialTimelineState).case(_actions.addProviderToTimeline, (state, {
  id,
  dataProvider
}) => ({
  ...state,
  timelineById: (0, _helpers.addProviderToTimelineHelper)(id, dataProvider, state.timelineById)
})).build();