"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addProviderToTimelineHelper = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addProviderToTimelineHelper = (id, provider, timelineById) => {
  const timeline = timelineById[id];
  const alreadyExistsAtIndex = timeline.dataProviders.findIndex(p => p.id === provider.id);
  if (alreadyExistsAtIndex > -1 && !(0, _lodash.isEmpty)(timeline.dataProviders[alreadyExistsAtIndex].and)) {
    provider.id = `${provider.id}-${timeline.dataProviders.filter(p => p.id === provider.id).length}`;
  }
  const dataProviders = alreadyExistsAtIndex > -1 && (0, _lodash.isEmpty)(timeline.dataProviders[alreadyExistsAtIndex].and) ? [...timeline.dataProviders.slice(0, alreadyExistsAtIndex), provider, ...timeline.dataProviders.slice(alreadyExistsAtIndex + 1)] : [...timeline.dataProviders, provider];
  return {
    ...timelineById,
    [id]: {
      ...timeline,
      dataProviders
    }
  };
};
exports.addProviderToTimelineHelper = addProviderToTimelineHelper;