"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipWithKeyboardShortcut = exports.PRESS = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRESS = exports.PRESS = _i18n.i18n.translate('xpack.timelines.hoverActions.tooltipWithKeyboardShortcut.pressTooltipLabel', {
  defaultMessage: 'Press'
});
const TooltipWithKeyboardShortcutComponent = ({
  additionalScreenReaderOnlyContext = '',
  content,
  shortcut,
  showShortcut
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "content"
}, content), additionalScreenReaderOnlyContext !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
  "data-test-subj": "additionalScreenReaderOnlyContext"
}, /*#__PURE__*/_react.default.createElement("p", null, additionalScreenReaderOnlyContext)), showShortcut && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  "data-test-subj": "shortcut",
  size: "s",
  textAlign: "center"
}, /*#__PURE__*/_react.default.createElement("span", null, PRESS), '\u00a0', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "hollow"
}, shortcut)));
const TooltipWithKeyboardShortcut = exports.TooltipWithKeyboardShortcut = /*#__PURE__*/_react.default.memo(TooltipWithKeyboardShortcutComponent);
TooltipWithKeyboardShortcut.displayName = 'TooltipWithKeyboardShortcut';