"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumnSettings = exports.DEFAULT_COLUMNS = void 0;
var _react = require("react");
var _negate = _interopRequireDefault(require("lodash/negate"));
var _indicator = require("../../../../common/types/indicator");
var _use_kibana = require("../../../hooks/use_kibana");
var _field_label = require("../components/common/field_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_COLUMNS = exports.DEFAULT_COLUMNS = [_indicator.RawIndicatorFieldId.TimeStamp, _indicator.RawIndicatorFieldId.Name, _indicator.RawIndicatorFieldId.Type, _indicator.RawIndicatorFieldId.Feed, _indicator.RawIndicatorFieldId.FirstSeen, _indicator.RawIndicatorFieldId.LastSeen].map(field => ({
  id: field,
  displayAsText: (0, _field_label.translateFieldLabel)(field)
}));
const DEFAULT_VISIBLE_COLUMNS = DEFAULT_COLUMNS.map(column => column.id);
const INDICATORS_TABLE_STORAGE = 'indicatorsTable';
const useColumnSettings = () => {
  const {
    services: {
      storage
    }
  } = (0, _use_kibana.useKibana)();
  const [sortingState, setSortingState] = (0, _react.useState)([]);
  const sorting = (0, _react.useMemo)(() => ({
    columns: sortingState,
    onSort: setSortingState
  }), [sortingState]);
  const [columns, setColumns] = (0, _react.useState)([]);
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)([]);

  /** Deserialize preferences on mount */
  (0, _react.useEffect)(() => {
    const {
      visibleColumns: cachedVisibleColumns = [],
      columns: cachedColumns = [],
      sortingState: cachedSortingState = []
    } = storage.get(INDICATORS_TABLE_STORAGE) || {
      visibleColumns: DEFAULT_VISIBLE_COLUMNS,
      columns: DEFAULT_COLUMNS,
      sortingState: []
    };
    setVisibleColumns(cachedVisibleColumns);
    setColumns(cachedColumns);
    setSortingState(cachedSortingState);
  }, [storage]);

  /** Ensure preferences are serialized into plugin storage on change */
  (0, _react.useEffect)(() => {
    storage.set(INDICATORS_TABLE_STORAGE, {
      visibleColumns,
      columns,
      sortingState
    });
  }, [columns, sortingState, storage, visibleColumns]);

  /** Toggle column and adjust its visibility */
  const handleToggleColumn = (0, _react.useCallback)(columnId => {
    setColumns(currentColumns => {
      const columnsMatchingId = ({
        id
      }) => id === columnId;
      const columnsNotMatchingId = (0, _negate.default)(columnsMatchingId);
      const enabled = Boolean(currentColumns.find(columnsMatchingId));
      if (enabled) {
        return currentColumns.filter(columnsNotMatchingId);
      }
      return [...currentColumns, {
        id: columnId,
        displayAsText: columnId
      }];
    });
    setVisibleColumns(currentlyVisibleColumns => {
      const matchById = id => id === columnId;
      const notMatchingId = (0, _negate.default)(matchById);
      const enabled = Boolean(currentlyVisibleColumns.find(matchById));
      if (enabled) {
        return currentlyVisibleColumns.filter(notMatchingId);
      }
      return [...currentlyVisibleColumns, columnId];
    });
  }, []);
  const handleResetColumns = (0, _react.useCallback)(() => {
    setColumns(DEFAULT_COLUMNS);
    setVisibleColumns(DEFAULT_VISIBLE_COLUMNS);
  }, []);
  const columnVisibility = (0, _react.useMemo)(() => ({
    visibleColumns,
    setVisibleColumns: setVisibleColumns
  }), [visibleColumns]);
  return {
    handleResetColumns,
    handleToggleColumn,
    columns,
    columnVisibility,
    sorting
  };
};
exports.useColumnSettings = useColumnSettings;