"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorFieldValue = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _use_field_types = require("../../../../hooks/use_field_types");
var _common = require("../../../../constants/common");
var _indicator = require("../../../../../common/types/indicator");
var _date_formatter = require("../../../../components/date_formatter");
var _unwrap_value = require("../../utils/unwrap_value");
var _tlp_badge = require("./tlp_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders an indicator field value based on its type:
 * - TLP fields → `<TLPBadge />`
 * - Date fields → `<DateFormatter />`
 * - Missing value → {@link EMPTY_VALUE}
 * - String or string[] → renders each value in a vertical column
 */

const IndicatorFieldValue = ({
  indicator,
  field
}) => {
  const fieldType = (0, _use_field_types.useFieldTypes)()[field];
  const value = (0, _unwrap_value.unwrapValue)(indicator, field);
  if (field === _indicator.RawIndicatorFieldId.MarkingTLP && !(0, _lodash.isArray)(value)) {
    return /*#__PURE__*/_react.default.createElement(_tlp_badge.TLPBadge, {
      value: value
    });
  }
  if (fieldType === 'date') {
    return /*#__PURE__*/_react.default.createElement(_date_formatter.DateFormatter, {
      date: value
    });
  }
  if (!value) {
    return _common.EMPTY_VALUE;
  }
  const values = [value].flat();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        display: flex;
        flex-direction: column;
      `
  }, values.map((val, idx) => /*#__PURE__*/_react.default.createElement("span", {
    key: `${value}-${idx}`
  }, val)));
};
exports.IndicatorFieldValue = IndicatorFieldValue;