"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsBarChartWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _indicator = require("../../../../../common/types/indicator");
var _field_selector = require("./field_selector");
var _barchart = require("./barchart");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIELD = _indicator.RawIndicatorFieldId.Feed;
/**
 * Displays the {@link IndicatorsBarChart} and {@link IndicatorsFieldSelector} components,
 * and handles retrieving aggregated indicator data.
 */
const IndicatorsBarChartWrapper = exports.IndicatorsBarChartWrapper = /*#__PURE__*/(0, _react.memo)(({
  timeRange,
  isLoading,
  isFetching,
  series,
  dateRange,
  field,
  onFieldChange
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: false,
      paddingSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": _test_ids.LOADING_TEST_ID,
      size: "xl"
    }))));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.indicator.barchartSection.title",
    defaultMessage: "Trend"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_selector.IndicatorsFieldSelector, {
    defaultStackByValue: DEFAULT_FIELD,
    valueChange: onFieldChange
  }))), isFetching && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": _test_ids.CHART_UPDATE_PROGRESS_TEST_ID,
    size: "xs",
    color: "accent",
    position: "absolute"
  }), timeRange && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.BARCHART_WRAPPER_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_barchart.IndicatorsBarChart, {
    indicators: series,
    dateRange: dateRange,
    field: field
  })));
});