"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INTEGRATION_LINK_ID = exports.EmptyPage = exports.EMPTY_PROMPT_TEST_ID = exports.DOCS_LINK_TEST_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("./translations");
var _use_documentation_link = require("../../hooks/use_documentation_link");
var _use_integrations_page_link = require("../../hooks/use_integrations_page_link");
var _integrations_light = _interopRequireDefault(require("./integrations_light.svg"));
var _security_solution_plugin_template_wrapper = require("../../containers/security_solution_plugin_template_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DOCS_LINK_TEST_ID = exports.DOCS_LINK_TEST_ID = 'tiEmptyPageDocsLink';
const EMPTY_PROMPT_TEST_ID = exports.EMPTY_PROMPT_TEST_ID = 'tiEmptyPage';
const INTEGRATION_LINK_ID = exports.INTEGRATION_LINK_ID = 'tiEmptyPageIntegrationsPageLink';
const EmptyPage = () => {
  const integrationsPageLink = (0, _use_integrations_page_link.useIntegrationsPageLink)();
  const documentationLink = (0, _use_documentation_link.useTIDocumentationLink)();
  return /*#__PURE__*/_react.default.createElement(_security_solution_plugin_template_wrapper.SecuritySolutionPluginTemplateWrapper, {
    isEmptyState: true,
    emptyPageBody: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        size: "fullWidth",
        alt: _translations.IMAGE,
        src: _integrations_light.default
      }),
      title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.threatIntelligence.common.emptyPage.title",
        defaultMessage: "Get started with Elastic Threat Intelligence"
      })),
      titleSize: "s",
      layout: "horizontal",
      color: "transparent",
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.threatIntelligence.common.emptyPage.body1",
        defaultMessage: "Elastic Threat Intelligence makes it easy to analyze and investigate potential security threats by aggregating data from multiple sources in one place."
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.threatIntelligence.common.emptyPage.body2",
        defaultMessage: "You\u2019ll be able to view data from all activated threat intelligence feeds and take action from this page."
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.threatIntelligence.common.emptyPage.body3",
        defaultMessage: "To get started with Elastic Threat Intelligence, enable one or more Threat Intelligence Integrations from the Integrations page or ingest data using filebeat. For more information, view the {docsLink}.",
        values: {
          docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: documentationLink,
            target: "_blank",
            "data-test-subj": DOCS_LINK_TEST_ID
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.threatIntelligence.common.emptyPage.docsLinkText",
            defaultMessage: "Security app documentation"
          }))
        }
      }))),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": INTEGRATION_LINK_ID,
        href: integrationsPageLink,
        color: "primary",
        iconType: "plusInCircle",
        fill: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.threatIntelligence.common.emptyPage.buttonText",
        defaultMessage: "Add Integrations"
      })),
      "data-test-subj": EMPTY_PROMPT_TEST_ID
    })
  });
};
exports.EmptyPage = EmptyPage;