"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EphemeralTaskRejectedDueToCapacityError = void 0;
Object.defineProperty(exports, "TaskErrorSource", {
  enumerable: true,
  get: function () {
    return _common.TaskErrorSource;
  }
});
exports.createRetryableError = createRetryableError;
exports.createTaskRunError = createTaskRunError;
exports.getErrorSource = getErrorSource;
exports.isEphemeralTaskRejectedDueToCapacityError = isEphemeralTaskRejectedDueToCapacityError;
exports.isRetryableError = isRetryableError;
exports.isUnrecoverableError = isUnrecoverableError;
exports.isUserError = isUserError;
exports.throwRetryableError = throwRetryableError;
exports.throwUnrecoverableError = throwUnrecoverableError;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Unrecoverable
const CODE_UNRECOVERABLE = 'TaskManager/unrecoverable';
const CODE_RETRYABLE = 'TaskManager/retryable';
const code = Symbol('TaskManagerErrorCode');
const retry = Symbol('TaskManagerErrorRetry');
const source = Symbol('TaskManagerErrorSource');
class EphemeralTaskRejectedDueToCapacityError extends Error {
  constructor(message, task) {
    super(message);
    (0, _defineProperty2.default)(this, "_task", void 0);
    this._task = task;
  }
  get task() {
    return this._task;
  }
}
exports.EphemeralTaskRejectedDueToCapacityError = EphemeralTaskRejectedDueToCapacityError;
function isTaskManagerError(error) {
  return Boolean(error && error[code]);
}
function isUnrecoverableError(error) {
  return isTaskManagerError(error) && error[code] === CODE_UNRECOVERABLE;
}
function throwUnrecoverableError(error) {
  error[code] = CODE_UNRECOVERABLE;
  throw error;
}
function isRetryableError(error) {
  if (isTaskManagerError(error) && error[code] === CODE_RETRYABLE) {
    return error[retry];
  }
  return null;
}
function createRetryableError(error, shouldRetry) {
  error[code] = CODE_RETRYABLE;
  error[retry] = shouldRetry;
  return error;
}
function throwRetryableError(error, shouldRetry) {
  throw createRetryableError(error, shouldRetry);
}
function createTaskRunError(error, errorSource = _common.TaskErrorSource.FRAMEWORK) {
  error[source] = errorSource;
  return error;
}
function isTaskRunError(error) {
  return Boolean(error && error[source]);
}
function getErrorSource(error) {
  if (isTaskRunError(error) && error[source]) {
    return error[source];
  }
}
function isUserError(error) {
  return getErrorSource(error) === _common.TaskErrorSource.USER;
}
function isEphemeralTaskRejectedDueToCapacityError(error) {
  return Boolean(error && error instanceof EphemeralTaskRejectedDueToCapacityError);
}