"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCapacityInWorkers = exports.getCapacityInCost = void 0;
var _task = require("../task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// When configured capacity is the number of normal cost tasks that this Kibana
// can run, the total available workers equals the capacity
const getCapacityInWorkers = capacity => capacity;

// When configured capacity is the number of normal cost tasks that this Kibana
// can run, the total available cost equals the capacity multiplied by the cost of a normal task
exports.getCapacityInWorkers = getCapacityInWorkers;
const getCapacityInCost = capacity => capacity * _task.TaskCost.Normal;
exports.getCapacityInCost = getCapacityInCost;