"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assignPodPartitions = assignPodPartitions;
exports.getPartitionMap = getPartitionMap;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPartitionMap({
  kibanasPerPartition,
  podNames,
  partitions
}) {
  const map = {};
  let counter = 0;
  for (const partition of partitions) {
    map[partition] = [];
    for (let i = 0; i < kibanasPerPartition; i++) {
      map[partition].push(podNames.sort()[counter++ % podNames.length]);
    }
  }
  return map;
}
function assignPodPartitions({
  kibanasPerPartition,
  podName,
  podNames,
  partitions
}) {
  const map = getPartitionMap({
    kibanasPerPartition,
    podNames,
    partitions
  });
  const podPartitions = [];
  for (const partition of Object.keys(map)) {
    if (map[Number(partition)].indexOf(podName) !== -1) {
      podPartitions.push(Number(partition));
    }
  }
  return podPartitions;
}