"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tcpFormatters = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _formatting_utils = require("./formatting_utils");
var _tls_formatters = require("./tls_formatters");
var _common_formatters = require("./common_formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tcpFormatters = exports.tcpFormatters = {
  ..._common_formatters.commonFormatters,
  ..._tls_formatters.tlsFormatters,
  [_runtime_types.ConfigKey.METADATA]: _formatting_utils.objectToJsonFormatter,
  [_runtime_types.ConfigKey.HOSTS]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PROXY_USE_LOCAL_RESOLVER]: null,
  [_runtime_types.ConfigKey.RESPONSE_RECEIVE_CHECK]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.REQUEST_SEND_CHECK]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PROXY_URL]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PORT]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.URLS]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.MODE]: null,
  [_runtime_types.ConfigKey.IPV4]: null,
  [_runtime_types.ConfigKey.IPV6]: null
};