"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processorsFormatter = void 0;
var _lodash = require("lodash");
var _runtime_types = require("../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processorsFormatter = config => {
  var _config$ConfigKey$LAB, _config$ConfigKey$KIB;
  const labels = (_config$ConfigKey$LAB = config[_runtime_types.ConfigKey.LABELS]) !== null && _config$ConfigKey$LAB !== void 0 ? _config$ConfigKey$LAB : {};
  const kSpaces = (_config$ConfigKey$KIB = config[_runtime_types.ConfigKey.KIBANA_SPACES]) !== null && _config$ConfigKey$KIB !== void 0 ? _config$ConfigKey$KIB : [];
  const spaces = Array.from(new Set([config.space_id, ...kSpaces]));
  const processors = [{
    add_fields: {
      fields: {
        'monitor.fleet_managed': true,
        config_id: config.config_id,
        test_run_id: config.test_run_id,
        run_once: config.run_once,
        'monitor.id': config['monitor.id'],
        'monitor.project.name': config['monitor.project.name'],
        'monitor.project.id': config['monitor.project.id'],
        meta: {
          space_id: spaces.length === 1 ? spaces[0] : spaces
        },
        ...((0, _lodash.isEmpty)(labels) ? {} : {
          labels
        })
      },
      target: ''
    }
  }];
  return JSON.stringify(processors);
};
exports.processorsFormatter = processorsFormatter;