"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.secondsToCronFormatter = exports.replaceStringWithParams = exports.maxAttemptsFormatter = exports.inlineSourceFormatter = exports.hasNoParams = exports.handleMultilineStringFormatter = exports.formatMWs = void 0;
var _lodash = require("lodash");
var _lightweight_param_formatter = require("./lightweight_param_formatter");
var _variable_parser = _interopRequireDefault(require("./variable_parser"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const replaceStringWithParams = (value, params, logger) => {
  if (!value || typeof value === 'boolean' || (0, _lodash.isEmpty)(params)) {
    return value;
  }
  try {
    if (typeof value !== 'string') {
      const strValue = JSON.stringify(value);
      if (hasNoParams(strValue)) {
        return value;
      }
      const parsedVars = _variable_parser.default.parse(strValue);
      const parseValue = (0, _lightweight_param_formatter.replaceVarsWithParams)(parsedVars, params);
      return JSON.parse(parseValue);
    }
    if (hasNoParams(value)) {
      return value;
    }
    const parsedVars = _variable_parser.default.parse(value);
    if (allParamsAreMissing(parsedVars, params)) {
      return value;
    }
    return (0, _lightweight_param_formatter.replaceVarsWithParams)(parsedVars, params);
  } catch (e) {
    logger === null || logger === void 0 ? void 0 : logger.error(`error parsing vars for value ${JSON.stringify(value)}, ${e}`);
  }
  return value;
};
exports.replaceStringWithParams = replaceStringWithParams;
const allParamsAreMissing = (parsedVars, params) => {
  const hasDefault = parsedVars.some(parsedVar => parsedVar.type === 'var' && parsedVar.content.default);
  if (hasDefault) {
    return false;
  }
  const varKeys = parsedVars.filter(parsedVar => parsedVar.type === 'var').map(v => typeof v.content === 'string' ? v.content : v.content.name);
  return varKeys.every(v => !params[v]);
};
const SHELL_PARAMS_REGEX = /\$\{[a-zA-Z_][a-zA-Z0-9\._\-?:]*\}/g;
const hasNoParams = strVal => {
  return strVal.match(SHELL_PARAMS_REGEX) === null;
};
exports.hasNoParams = hasNoParams;
const secondsToCronFormatter = (fields, key) => {
  var _ref;
  const value = (_ref = fields[key]) !== null && _ref !== void 0 ? _ref : '';
  return value ? `${value}s` : null;
};
exports.secondsToCronFormatter = secondsToCronFormatter;
const maxAttemptsFormatter = (fields, key) => {
  var _ref2;
  return (_ref2 = fields[key]) !== null && _ref2 !== void 0 ? _ref2 : 2;
};
exports.maxAttemptsFormatter = maxAttemptsFormatter;
var Frequency = /*#__PURE__*/function (Frequency) {
  Frequency[Frequency["YEARLY"] = 0] = "YEARLY";
  Frequency[Frequency["MONTHLY"] = 1] = "MONTHLY";
  Frequency[Frequency["WEEKLY"] = 2] = "WEEKLY";
  Frequency[Frequency["DAILY"] = 3] = "DAILY";
  Frequency[Frequency["HOURLY"] = 4] = "HOURLY";
  Frequency[Frequency["MINUTELY"] = 5] = "MINUTELY";
  Frequency[Frequency["SECONDLY"] = 6] = "SECONDLY";
  return Frequency;
}(Frequency || {});
function frequencyToString(value) {
  if (value === undefined || value === null) {
    return;
  }
  const name = Frequency[value];
  return name ? name.toLowerCase() : 'unknown';
}
const formatMWs = (mws, strRes = true) => {
  if (!mws) {
    return;
  }
  const formatted = mws.map(mw => {
    const mwRule = mw === null || mw === void 0 ? void 0 : mw.rRule;
    if (mw && mwRule) {
      return {
        ...mwRule,
        freq: frequencyToString(mwRule.freq),
        duration: `${mw.duration}ms`
      };
    }
  });
  if (!strRes) {
    return formatted;
  }
  return JSON.stringify(formatted);
};
exports.formatMWs = formatMWs;
function escapeTemplateLiterals(script) {
  return script.replace(/\$\{/g, '$$${');
}
const inlineSourceFormatter = (fields, key) => {
  const value = fields[key];
  if (!(value !== null && value !== void 0 && value.trim())) return value;

  // Escape template literals to prevent unintended interpolation
  return escapeTemplateLiterals(value).trim();
};
exports.inlineSourceFormatter = inlineSourceFormatter;
const handleMultilineStringFormatter = value => {
  return value.replace(/(\n+)/g, '$1\n');
};
exports.handleMultilineStringFormatter = handleMultilineStringFormatter;