"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.triggerTestNow = exports.testNowMonitorRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _uuid = require("uuid");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
var _utils = require("../monitor_cruds/add_monitor/utils");
var _service_errors = require("./service_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const testNowMonitorRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.TRIGGER_MONITOR + '/{monitorId}',
  validate: {
    params: _configSchema.schema.object({
      monitorId: _configSchema.schema.string({
        minLength: 1,
        maxLength: 1024
      })
    })
  },
  handler: async routeContext => {
    const {
      monitorId
    } = routeContext.request.params;
    return triggerTestNow(monitorId, routeContext);
  },
  writeAccess: true
});
exports.testNowMonitorRoute = testNowMonitorRoute;
const triggerTestNow = async (monitorId, routeContext) => {
  const {
    spaceId,
    syntheticsMonitorClient,
    savedObjectsClient,
    response,
    monitorConfigRepository
  } = routeContext;
  try {
    const {
      normalizedMonitor
    } = await monitorConfigRepository.getDecrypted(monitorId, spaceId);
    const {
      [_runtime_types.ConfigKey.SCHEDULE]: schedule,
      [_runtime_types.ConfigKey.LOCATIONS]: locations
    } = normalizedMonitor.attributes;
    const privateLocations = await (0, _utils.getPrivateLocationsForMonitor)(savedObjectsClient, normalizedMonitor.attributes);
    const testRunId = (0, _uuid.v4)();
    const [, errors] = await syntheticsMonitorClient.testNowConfigs({
      monitor: normalizedMonitor.attributes,
      id: monitorId,
      testRunId
    }, savedObjectsClient, privateLocations, spaceId);
    if (errors && (errors === null || errors === void 0 ? void 0 : errors.length) > 0) {
      return {
        errors,
        testRunId,
        schedule,
        locations,
        configId: monitorId,
        monitor: normalizedMonitor.attributes
      };
    }
    return {
      testRunId,
      schedule,
      locations,
      configId: monitorId,
      monitor: normalizedMonitor.attributes
    };
  } catch (getErr) {
    if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(getErr)) {
      return (0, _service_errors.getMonitorNotFoundResponse)(response, monitorId);
    }
    throw getErr;
  }
};
exports.triggerTestNow = triggerTestNow;