"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupPrivateLocationRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _feature = require("../../../feature");
var _constants = require("../../../../common/constants");
var _sync_private_locations_monitors_task = require("../../../tasks/sync_private_locations_monitors_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cleanupPrivateLocationRoute = () => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS_CLEANUP,
  validate: {
    query: _configSchema.schema.object({
      hasAlreadyDoneCleanup: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })
  },
  requiredPrivileges: [_feature.PRIVATE_LOCATION_WRITE_API],
  handler: async routeContext => {
    const {
      server,
      request
    } = routeContext;
    const {
      hasAlreadyDoneCleanup
    } = request.query;
    await (0, _sync_private_locations_monitors_task.resetSyncPrivateCleanUpState)({
      server,
      hasAlreadyDoneCleanup
    });
    return {
      success: true,
      message: 'Task to start clean up has been started, it may take a while.'
    };
  }
});
exports.cleanupPrivateLocationRoute = cleanupPrivateLocationRoute;