"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncParamsSettingsParamsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _sync_private_locations_monitors_task = require("../../../tasks/sync_private_locations_monitors_task");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syncParamsSettingsParamsRoute = () => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.SYNC_GLOBAL_PARAMS_SETTINGS,
  validate: {
    body: _configSchema.schema.object({
      enable: _configSchema.schema.boolean()
    })
  },
  writeAccess: true,
  handler: async ({
    server,
    request
  }) => {
    const {
      enable
    } = request.body;
    await (0, _sync_private_locations_monitors_task.disableSyncPrivateLocationTask)({
      server,
      disableAutoSync: !enable
    });
    return {
      success: true
    };
  }
});
exports.syncParamsSettingsParamsRoute = syncParamsSettingsParamsRoute;