"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSyntheticsParamsRoute = void 0;
exports.getExistingParamsSpaces = getExistingParamsSpaces;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _saved_objects = require("../../../../common/types/saved_objects");
var _constants = require("../../../../common/constants");
var _sync_global_params_task = require("../../../tasks/sync_global_params_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSyntheticsParamsRoute = () => ({
  method: 'DELETE',
  path: _constants.SYNTHETICS_API_URLS.PARAMS + '/{id?}',
  validate: {},
  validation: {
    request: {
      body: _configSchema.schema.nullable(_configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          minSize: 1
        })
      })),
      params: _configSchema.schema.object({
        id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  },
  handler: async ({
    savedObjectsClient,
    request,
    response,
    server
  }) => {
    var _request$body, _request$params;
    const {
      ids
    } = (_request$body = request.body) !== null && _request$body !== void 0 ? _request$body : {};
    const {
      id: paramId
    } = (_request$params = request.params) !== null && _request$params !== void 0 ? _request$params : {};
    if (ids && paramId) {
      return response.badRequest({
        body: _i18n.i18n.translate('xpack.synthetics.deleteParam.errorMultipleIdsProvided', {
          defaultMessage: `Both param id  and body parameters cannot be provided`
        })
      });
    }
    const idsToDelete = ids !== null && ids !== void 0 ? ids : [paramId];
    if (idsToDelete.length === 0) {
      return response.badRequest({
        body: _i18n.i18n.translate('xpack.synthetics.deleteParam.errorNoIdsProvided', {
          defaultMessage: `No param ids provided`
        })
      });
    }
    const existingParamsSpaces = await getExistingParamsSpaces(savedObjectsClient, idsToDelete);
    const result = await savedObjectsClient.bulkDelete(idsToDelete.map(id => ({
      type: _saved_objects.syntheticsParamType,
      id
    })), {
      force: true
    });
    await (0, _sync_global_params_task.asyncGlobalParamsPropagation)({
      server,
      paramsSpacesToSync: existingParamsSpaces
    });
    return result.statuses.map(({
      id,
      success
    }) => ({
      id,
      deleted: success
    }));
  }
});
exports.deleteSyntheticsParamsRoute = deleteSyntheticsParamsRoute;
async function getExistingParamsSpaces(savedObjectsClient, paramIds) {
  const existingParam = await savedObjectsClient.bulkGet(paramIds.map(id => ({
    type: _saved_objects.syntheticsParamType,
    id
  })));
  return Array.from(new Set(existingParam.saved_objects.reduce((spaces, obj) => {
    var _obj$namespaces;
    return spaces.concat((_obj$namespaces = obj.namespaces) !== null && _obj$namespaces !== void 0 ? _obj$namespaces : []);
  }, [])));
}