"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSyntheticsParamsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("@kbn/security-plugin/common/constants");
var _common = require("@kbn/spaces-plugin/common");
var _saved_objects = require("../../../../common/types/saved_objects");
var _constants2 = require("../../../../common/constants");
var _sync_global_params_task = require("../../../tasks/sync_global_params_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ParamsObjectSchema = _configSchema.schema.object({
  key: _configSchema.schema.string({
    minLength: 1
  }),
  value: _configSchema.schema.string({
    minLength: 1
  }),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  share_across_spaces: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const addSyntheticsParamsRoute = () => ({
  method: 'POST',
  path: _constants2.SYNTHETICS_API_URLS.PARAMS,
  validate: {},
  validation: {
    request: {
      body: _configSchema.schema.oneOf([ParamsObjectSchema, _configSchema.schema.arrayOf(ParamsObjectSchema)])
    }
  },
  handler: async ({
    request,
    response,
    server,
    savedObjectsClient
  }) => {
    try {
      var _await$server$spaces$, _server$spaces;
      const {
        id: spaceId
      } = (_await$server$spaces$ = await ((_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getActiveSpace(request))) !== null && _await$server$spaces$ !== void 0 ? _await$server$spaces$ : {
        id: _common.DEFAULT_SPACE_ID
      };
      const savedObjectsData = parseParamBody(spaceId, request.body);
      const result = await savedObjectsClient.bulkCreate(savedObjectsData);
      await (0, _sync_global_params_task.asyncGlobalParamsPropagation)({
        server,
        paramsSpacesToSync: Array.from(new Set(savedObjectsData.reduce((spacesToSync, obj) => spacesToSync.concat(obj.initialNamespaces || []), [])))
      });
      if (savedObjectsData.length > 1) {
        return result.saved_objects.map(savedObject => {
          return toClientResponse(savedObject);
        });
      } else {
        return toClientResponse(result.saved_objects[0]);
      }
    } catch (error) {
      var _error$output;
      if (((_error$output = error.output) === null || _error$output === void 0 ? void 0 : _error$output.statusCode) === 404) {
        var _server$spaces$spaces, _server$spaces2;
        const spaceId = (_server$spaces$spaces = (_server$spaces2 = server.spaces) === null || _server$spaces2 === void 0 ? void 0 : _server$spaces2.spacesService.getSpaceId(request)) !== null && _server$spaces$spaces !== void 0 ? _server$spaces$spaces : _common.DEFAULT_SPACE_ID;
        return response.notFound({
          body: {
            message: `Kibana space '${spaceId}' does not exist`
          }
        });
      }
      throw error;
    }
  }
});
exports.addSyntheticsParamsRoute = addSyntheticsParamsRoute;
const toClientResponse = savedObject => {
  const {
    id,
    attributes: data,
    namespaces
  } = savedObject;
  const {
    description,
    key,
    tags
  } = data;
  return {
    id,
    description,
    key,
    namespaces,
    tags,
    value: data.value
  };
};
const parseParamBody = (spaceId, body) => {
  if (Array.isArray(body)) {
    const params = body;
    return params.map(param => {
      const {
        share_across_spaces: shareAcrossSpaces,
        ...data
      } = param;
      return {
        type: _saved_objects.syntheticsParamType,
        attributes: data,
        initialNamespaces: shareAcrossSpaces ? [_constants.ALL_SPACES_ID] : [spaceId]
      };
    });
  }
  const {
    share_across_spaces: shareAcrossSpaces,
    ...data
  } = body;
  return [{
    type: _saved_objects.syntheticsParamType,
    attributes: data,
    initialNamespaces: shareAcrossSpaces ? [_constants.ALL_SPACES_ID] : [spaceId]
  }];
};