"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsCertsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _saved_objects = require("../../../common/types/saved_objects");
var _process_monitors = require("../../saved_objects/synthetics_monitor/process_monitors");
var _constants = require("../../../common/constants");
var _monitor_management = require("../../../common/constants/monitor_management");
var _get_certs = require("../../queries/get_certs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsCertsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.CERTS,
  validate: {
    query: _configSchema.schema.object({
      pageIndex: _configSchema.schema.maybe(_configSchema.schema.number()),
      size: _configSchema.schema.maybe(_configSchema.schema.number()),
      sortBy: _configSchema.schema.maybe(_configSchema.schema.string()),
      direction: _configSchema.schema.maybe(_configSchema.schema.string()),
      search: _configSchema.schema.maybe(_configSchema.schema.string()),
      from: _configSchema.schema.maybe(_configSchema.schema.string()),
      to: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  },
  handler: async ({
    request,
    syntheticsEsClient,
    monitorConfigRepository
  }) => {
    const queryParams = request.query;
    const monitors = await monitorConfigRepository.getAll({
      filter: `${_saved_objects.syntheticsMonitorAttributes}.${_monitor_management.ConfigKey.ENABLED}: true`
    });
    if (monitors.length === 0) {
      return {
        data: {
          certs: [],
          total: 0
        }
      };
    }
    const {
      enabledMonitorQueryIds
    } = (0, _process_monitors.processMonitors)(monitors);
    const data = await (0, _get_certs.getSyntheticsCerts)({
      ...queryParams,
      syntheticsEsClient,
      monitorIds: enabledMonitorQueryIds
    });
    return {
      data
    };
  }
});
exports.getSyntheticsCertsRoute = getSyntheticsCertsRoute;