"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkIsStalePing = checkIsStalePing;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the loaded/cached pings are of the current selected monitors
 */
function checkIsStalePing(monitorOrConfigId, ping) {
  var _ping$monitor;
  if (!monitorOrConfigId || !(ping !== null && ping !== void 0 && (_ping$monitor = ping.monitor) !== null && _ping$monitor !== void 0 && _ping$monitor.id)) {
    return true;
  }
  return monitorOrConfigId !== ping.monitor.id && monitorOrConfigId !== ping.config_id;
}