"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyntheticsEnablementEffect = fetchSyntheticsEnablementEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _actions = require("./actions");
var _fetch_effect = require("../utils/fetch_effect");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchSyntheticsEnablementEffect() {
  yield (0, _effects.takeLeading)(_actions.getSyntheticsEnablement, (0, _fetch_effect.fetchEffectFactory)(_api.fetchGetSyntheticsEnablement, _actions.getSyntheticsEnablementSuccess, _actions.getSyntheticsEnablementFailure, undefined, failureMessage));
}
const failureMessage = _i18n.i18n.translate('xpack.synthetics.settings.enablement.fail', {
  defaultMessage: 'Failed to enable Synthetics App'
});