"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyntheticsMonitor = exports.fetchMonitorRecentPings = exports.fetchLatestTestRun = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _api_service = require("../../../../utils/api_service");
var _runtime_types = require("../../../../../common/runtime_types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMonitorRecentPings = async ({
  monitorId,
  locationId,
  from,
  to,
  size = 10,
  pageIndex = 0,
  statusFilter
}) => {
  const locations = JSON.stringify([locationId]);
  const sort = 'desc';
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PINGS, {
    monitorId,
    from: from !== null && from !== void 0 ? from : (0, _moment.default)().subtract(30, 'days').toISOString(),
    to: to !== null && to !== void 0 ? to : (0, _moment.default)().toISOString(),
    locations,
    sort,
    size,
    pageIndex,
    status: statusFilter
  }, _runtime_types.PingsResponseType);
};
exports.fetchMonitorRecentPings = fetchMonitorRecentPings;
const fetchLatestTestRun = async ({
  monitorId,
  locationLabel
}) => {
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.LATEST_TEST_RUN, {
    monitorId,
    locationLabel,
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.fetchLatestTestRun = fetchLatestTestRun;
const fetchSyntheticsMonitor = async ({
  monitorId,
  spaceId
}) => {
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.GET_SYNTHETICS_MONITOR.replace('{monitorId}', monitorId), {
    internal: true,
    spaceId,
    version: _constants.INITIAL_REST_VERSION
  }, _runtime_types.EncryptedSyntheticsMonitorCodec);
};
exports.fetchSyntheticsMonitor = fetchSyntheticsMonitor;