"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorAlertEnable = useMonitorAlertEnable;
var _react = require("react");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _alert_config = require("../../../../common/runtime_types/monitor_management/alert_config");
var _types = require("../components/monitors_page/overview/types");
var _state = require("../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorAlertEnable() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const upsertStatuses = (0, _reactRedux.useSelector)(_state.selectMonitorUpsertStatuses);
  const alertStatus = (0, _react.useCallback)(configId => {
    var _upsertStatuses$confi;
    return (_upsertStatuses$confi = upsertStatuses[configId]) === null || _upsertStatuses$confi === void 0 ? void 0 : _upsertStatuses$confi.alertStatus;
  }, [upsertStatuses]);
  const updateAlertEnabledState = (0, _react.useCallback)(({
    monitor,
    name,
    configId
  }) => {
    dispatch(_state.enableMonitorAlertAction.get({
      configId,
      monitor,
      success: {
        message: (0, _alert_config.isStatusEnabled)(monitor[_types.ConfigKey.ALERT_CONFIG]) ? enabledSuccessLabel(name) : disabledSuccessLabel(name),
        lifetimeMs: 3000,
        testAttribute: 'uptimeMonitorAlertUpdateSuccess'
      },
      error: {
        message: {
          title: enabledFailLabel(name)
        },
        lifetimeMs: 10000,
        testAttribute: 'uptimeMonitorAlertEnabledUpdateFailure'
      }
    }));
  }, [dispatch]);
  return {
    updateAlertEnabledState,
    alertStatus
  };
}
const enabledSuccessLabel = name => _i18n.i18n.translate('xpack.synthetics.overview.actions.enabledSuccessLabel.alert', {
  defaultMessage: 'Alerts are now enabled for the monitor "{name}".',
  values: {
    name
  }
});
const disabledSuccessLabel = name => _i18n.i18n.translate('xpack.synthetics.overview.actions.disabledSuccessLabel.alert', {
  defaultMessage: 'Alerts are now disabled for the monitor "{name}".',
  values: {
    name
  }
});
const enabledFailLabel = name => _i18n.i18n.translate('xpack.synthetics.overview.actions.enabledFailLabel.alert', {
  defaultMessage: 'Unable to enable status alerts for monitor "{name}".',
  values: {
    name
  }
});