"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestNowModeFlyout = TestNowModeFlyout;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
var _test_now_mode = require("./test_now_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TestNowModeFlyout({
  name,
  testRun,
  onClose,
  onDone,
  inProgress,
  isPushing,
  errors,
  serviceError
}) {
  const flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    size: "m",
    paddingSize: "m",
    maxWidth: "44%",
    "aria-labelledby": TEST_RESULT,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, name, "-", TEST_RESULTS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
    sectionName: "xpack.synthetics.monitorManagement.testNowFlyout.body"
  }, isPushing && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, PushingLabel, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)), testRun ? /*#__PURE__*/_react.default.createElement(_test_now_mode.TestNowMode, {
    isPushing: isPushing,
    errors: errors,
    serviceError: serviceError,
    testRun: testRun,
    onDone: onDone
  }) : !isPushing && /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsTestNowModeFlyoutButton",
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, CLOSE_LABEL)));
  return testRun || inProgress ? flyout : null;
}
const TEST_RESULT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.testResult', {
  defaultMessage: 'Test result'
});
const TEST_RESULTS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.testResults', {
  defaultMessage: 'Test results'
});
const CLOSE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.closeButtonLabel', {
  defaultMessage: 'Close'
});
const PushingLabel = _i18n.i18n.translate('xpack.synthetics.testRun.pushing.description', {
  defaultMessage: 'Pushing the monitor to service...'
});