"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpandedPingList = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExpandedPingList = pings => {
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  const expandedIdsToRemove = JSON.stringify(Object.keys(expandedRows).filter(e => !pings.some(({
    docId
  }) => docId === e)));
  (0, _react.useEffect)(() => {
    const parsed = JSON.parse(expandedIdsToRemove);
    if (parsed.length) {
      parsed.forEach(docId => {
        delete expandedRows[docId];
      });
      setExpandedRows(expandedRows);
    }
  }, [expandedIdsToRemove, expandedRows]);
  return {
    expandedRows,
    setExpandedRows
  };
};
exports.useExpandedPingList = useExpandedPingList;