"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseCodeColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpanWithMargin = _styledComponents.default.span`
  margin-right: 16px;
`;
const ResponseCodeColumn = ({
  statusCode
}) => {
  return /*#__PURE__*/_react.default.createElement(SpanWithMargin, null, statusCode ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "pingResponseCode"
  }, statusCode) : '--');
};
exports.ResponseCodeColumn = ResponseCodeColumn;