"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObjectWeightList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _color_palette = require("./color_palette");
var _use_object_metrics = require("../hooks/use_object_metrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObjectWeightList = () => {
  const objectMetrics = (0, _use_object_metrics.useObjectMetrics)();
  const hasAnyThresholdBreach = objectMetrics.items.some(({
    weightDelta
  }) => Math.abs(Number(weightDelta)) > 5);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, OBJECT_WEIGHT_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, TOTAL_SIZE_LABEL, ":", ' ', /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontWeight: 'bold'
    }
  }, objectMetrics.totalObjectsWeight)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, objectMetrics.items.map(({
    label,
    mimeType,
    weightPercent,
    weight,
    weightDelta
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: mimeType
  }, /*#__PURE__*/_react.default.createElement(_color_palette.ColorPalette, {
    hasAnyThresholdBreach: hasAnyThresholdBreach,
    label: label,
    mimeType: mimeType,
    percent: weightPercent,
    value: weight,
    loading: objectMetrics.loading,
    delta: Number(weightDelta)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), ' '))));
};
exports.ObjectWeightList = ObjectWeightList;
const OBJECT_WEIGHT_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetails.objectWeight', {
  defaultMessage: 'Object weight'
});
const TOTAL_SIZE_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetails.totalSize', {
  defaultMessage: 'Total size'
});