"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDefaultsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _validation = require("./validation");
var _constants = require("../../../../../../common/constants");
var _default_email = require("./default_email");
var _selectors = require("../../../state/settings/selectors");
var _actions = require("../../../state/settings/actions");
var _connector_field = require("./connector_field");
var _use_alerting_defaults = require("./hooks/use_alerting_defaults");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertDefaultsForm = () => {
  var _useKibana$services, _useKibana$services$a, _formFields$defaultSt, _formFields$defaultTL;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    settings,
    loading
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const [formFields, setFormFields] = (0, _react.useState)(_constants.DYNAMIC_SETTINGS_DEFAULTS);
  const canEdit = !!((_useKibana$services = (0, _public.useKibana)().services) !== null && _useKibana$services !== void 0 && (_useKibana$services$a = _useKibana$services.application) !== null && _useKibana$services$a !== void 0 && _useKibana$services$a.capabilities.uptime.configureSettings) || false;
  const isDisabled = !canEdit;
  (0, _react.useEffect)(() => {
    if (settings) {
      setFormFields(settings);
    }
  }, [settings]);
  (0, _react.useEffect)(() => {
    dispatch(_actions.getDynamicSettingsAction.get());
  }, [dispatch]);
  const {
    connectors
  } = (0, _use_alerting_defaults.useAlertingDefaults)();
  const hasEmailConnector = connectors === null || connectors === void 0 ? void 0 : connectors.find(connector => {
    var _formFields$defaultCo;
    return ((_formFields$defaultCo = formFields.defaultConnectors) === null || _formFields$defaultCo === void 0 ? void 0 : _formFields$defaultCo.includes(connector.id)) && connector.actionTypeId === '.email';
  });
  const onApply = () => {
    dispatch(_actions.setDynamicSettingsAction.get(formFields));
  };
  const isFormDirty = !(0, _lodash.isEqual)(formFields, settings);
  const isFormValid = () => {
    if (hasEmailConnector) {
      return (0, _lodash.isEmpty)((0, _validation.hasInvalidEmail)(formFields === null || formFields === void 0 ? void 0 : formFields.defaultConnectors, formFields === null || formFields === void 0 ? void 0 : formFields.defaultEmail));
    }
    return true;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.settings.defaultConnectors",
      defaultMessage: "Default rules"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.settings.defaultConnectors.description",
      defaultMessage: "Default rules are automatically created. You can disable creation of default rules here."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.synthetics.ruleStatusDefaultsForm.euiSwitch.enabledLabel', {
      defaultMessage: 'Status rule enabled'
    }),
    checked: (_formFields$defaultSt = formFields === null || formFields === void 0 ? void 0 : formFields.defaultStatusRuleEnabled) !== null && _formFields$defaultSt !== void 0 ? _formFields$defaultSt : true,
    onChange: () => {
      var _formFields$defaultSt2;
      setFormFields({
        ...formFields,
        defaultStatusRuleEnabled: !((_formFields$defaultSt2 = formFields.defaultStatusRuleEnabled) !== null && _formFields$defaultSt2 !== void 0 ? _formFields$defaultSt2 : true)
      });
    },
    disabled: isDisabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.synthetics.ruleTLSDefaultsForm.euiSwitch.enabledLabel', {
      defaultMessage: 'TLS rule enabled'
    }),
    checked: (_formFields$defaultTL = formFields === null || formFields === void 0 ? void 0 : formFields.defaultTLSRuleEnabled) !== null && _formFields$defaultTL !== void 0 ? _formFields$defaultTL : true,
    onChange: () => {
      var _formFields$defaultTL2;
      setFormFields({
        ...formFields,
        defaultTLSRuleEnabled: !((_formFields$defaultTL2 = formFields.defaultTLSRuleEnabled) !== null && _formFields$defaultTL2 !== void 0 ? _formFields$defaultTL2 : true)
      });
    },
    disabled: isDisabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.settings.defaultConnectors",
      defaultMessage: "Default Connectors"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.settings.defaultConnectors.description",
      defaultMessage: "Select one or more connectors to be used for alerts. These settings apply to all synthetics-based alerts."
    })
  }, /*#__PURE__*/_react.default.createElement(_connector_field.DefaultConnectorField, {
    isDisabled: isDisabled,
    isLoading: loading,
    selectedConnectors: formFields.defaultConnectors,
    onChange: value => setFormFields({
      ...formFields,
      defaultConnectors: value
    })
  })), hasEmailConnector && /*#__PURE__*/_react.default.createElement(_default_email.DefaultEmail, {
    loading: loading,
    isDisabled: isDisabled,
    value: formFields.defaultEmail,
    selectedConnectors: formFields.defaultConnectors,
    onChange: value => setFormFields(prevStat => ({
      ...prevStat,
      defaultEmail: value
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsAlertDefaultsFormButton",
    iconType: "cross",
    onClick: () => {
      setFormFields(settings !== null && settings !== void 0 ? settings : _constants.DYNAMIC_SETTINGS_DEFAULTS);
    },
    flush: "left",
    isDisabled: !isFormDirty,
    isLoading: loading
  }, DISCARD_CHANGES)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsAlertDefaultsFormButton",
    onClick: evt => {
      evt.preventDefault();
      onApply();
    },
    fill: true,
    isLoading: loading,
    isDisabled: !isFormDirty || isDisabled || !isFormValid()
  }, APPLY_CHANGES))));
};
exports.AlertDefaultsForm = AlertDefaultsForm;
const DISCARD_CHANGES = _i18n.i18n.translate('xpack.synthetics.settings.discardChanges', {
  defaultMessage: 'Discard changes'
});
const APPLY_CHANGES = _i18n.i18n.translate('xpack.synthetics.settings.applyChanges', {
  defaultMessage: 'Apply changes'
});