"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _use_overview_trends_requests = require("../../hooks/use_overview_trends_requests");
var _show_all_spaces = require("../../common/show_all_spaces");
var _constants = require("../../../../../embeddables/constants");
var _add_to_dashboard = require("../../../common/components/add_to_dashboard");
var _use_overview_status = require("../../hooks/use_overview_status");
var _group_fields = require("./grid_by_group/group_fields");
var _overview = require("../../../../state/overview");
var _use_monitors_sorted_by_status = require("../../../../hooks/use_monitors_sorted_by_status");
var _overview_pagination_info = require("./overview_pagination_info");
var _sort_fields = require("./sort_fields");
var _no_monitors_found = require("../../common/no_monitors_found");
var _contexts = require("../../../../contexts");
var _monitor_detail_flyout = require("./monitor_detail_flyout");
var _overview_grid_compact_view = require("./compact_view/overview_grid_compact_view");
var _view_buttons = require("./view_buttons/view_buttons");
var _overview_card_view = require("./overview_cards_view/overview_card_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewGrid = exports.OverviewGrid = /*#__PURE__*/(0, _react.memo)(({
  view,
  isEmbeddable
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    status,
    loaded: isInitialized,
    loading
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const monitorsSortedByStatus = (0, _use_monitors_sorted_by_status.useMonitorsSortedByStatus)();
  const [maxItem, setMaxItem] = (0, _react.useState)(0);
  (0, _use_overview_trends_requests.useOverviewTrendsRequests)(monitorsSortedByStatus, maxItem);
  const setFlyoutConfigCallback = (0, _react.useCallback)(params => dispatch((0, _overview.setFlyoutConfig)(params)), [dispatch]);
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  (0, _react.useEffect)(() => {
    dispatch(_overview.refreshOverviewTrends.get());
  }, [dispatch, lastRefresh]);

  // Display no monitors found when down, up, or disabled filter produces no results
  if (status && !monitorsSortedByStatus.length && isInitialized) {
    return /*#__PURE__*/_react.default.createElement(_no_monitors_found.NoMonitorsFound, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_overview_pagination_info.OverviewPaginationInfo, {
    total: status ? monitorsSortedByStatus.length : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_show_all_spaces.ShowAllSpaces, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_to_dashboard.AddToDashboard, {
    type: _constants.SYNTHETICS_MONITORS_EMBEDDABLE,
    asButton: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sort_fields.SortFields, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_group_fields.GroupFields, null)), !isEmbeddable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_buttons.ViewButtons, null)) : null), loading && isInitialized ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    css: {
      blockSize: 14
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), view === 'cardView' ? /*#__PURE__*/_react.default.createElement(_overview_card_view.OverviewCardView, {
    monitorsSortedByStatus: monitorsSortedByStatus,
    maxItem: maxItem,
    setMaxItem: setMaxItem,
    setFlyoutConfigCallback: setFlyoutConfigCallback
  }) : view === 'compactView' ? /*#__PURE__*/_react.default.createElement(_overview_grid_compact_view.OverviewGridCompactView, {
    setFlyoutConfigCallback: setFlyoutConfigCallback
  }) : null, /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.MaybeMonitorDetailsFlyout, {
    setFlyoutConfigCallback: setFlyoutConfigCallback
  }));
});