"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorMWs = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorMWs = monitor => {
  var _data$filter;
  const services = (0, _public.useKibana)().services;
  const {
    data
  } = (0, _alertsUiShared.useFetchActiveMaintenanceWindows)(services, {
    enabled: true
  });
  const monitorMWs = monitor.maintenanceWindows;
  return {
    activeMWs: (_data$filter = data === null || data === void 0 ? void 0 : data.filter(mw => monitorMWs === null || monitorMWs === void 0 ? void 0 : monitorMWs.includes(mw.id))) !== null && _data$filter !== void 0 ? _data$filter : []
  };
};
exports.useMonitorMWs = useMonitorMWs;