"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseBodyIndexField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseBodyIndexField = ({
  defaultValue,
  onChange,
  onBlur,
  readOnly
}) => {
  const [policy, setPolicy] = (0, _react.useState)(defaultValue);
  const [checked, setChecked] = (0, _react.useState)(defaultValue !== _types.ResponseBodyIndexPolicy.NEVER);
  (0, _react.useEffect)(() => {
    if (checked) {
      const defaultOrSelected = policy === _types.ResponseBodyIndexPolicy.NEVER ? _types.ResponseBodyIndexPolicy.ON_ERROR : policy;
      setPolicy(defaultOrSelected);
      onChange(defaultOrSelected);
    } else {
      onChange(_types.ResponseBodyIndexPolicy.NEVER);
    }
  }, [checked, policy, setPolicy, onChange]);
  (0, _react.useEffect)(() => {
    onChange(policy);
  }, [onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "syntheticsIndexResponseBody"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "uptimeFleetIndexResponseBody",
    checked: checked,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.indexResponseBody.label",
      defaultMessage: "Index response body"
    }),
    onChange: event => {
      const checkedEvent = event.target.checked;
      setChecked(checkedEvent);
    },
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    disabled: readOnly
  })), checked && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.synthetics.monitorConfig.indexResponseBodyPolicy.label', {
      defaultMessage: 'Response body index policy'
    }),
    "data-test-subj": "indexResponseBodyFieldSelect",
    options: responseBodyIndexPolicyOptions,
    value: policy,
    onChange: event => {
      setPolicy(event.target.value);
    },
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    disabled: readOnly
  })));
};
exports.ResponseBodyIndexField = ResponseBodyIndexField;
const responseBodyIndexPolicyOptions = [{
  value: _types.ResponseBodyIndexPolicy.ON_ERROR,
  text: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.responseBodyIndex.onError', {
    defaultMessage: 'On error'
  })
}, {
  value: _types.ResponseBodyIndexPolicy.ALWAYS,
  text: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.responseBodyIndex.always', {
    defaultMessage: 'Always'
  })
}];