"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EXPLORE_LABEL = void 0;
exports.StepFieldTrend = StepFieldTrend;
exports.getLast48Intervals = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/exploratory-view-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLast48Intervals = activeStep => {
  const timestamp = activeStep['@timestamp'];
  const {
    lt,
    gte
  } = activeStep.monitor.timespan;
  const difference = (0, _moment.default)(lt).diff((0, _moment.default)(gte), 'millisecond') * 48;
  return {
    to: timestamp,
    from: (0, _moment.default)(timestamp).subtract(difference, 'millisecond').toISOString()
  };
};
exports.getLast48Intervals = getLast48Intervals;
function StepFieldTrend({
  title,
  field,
  step: activeStep
}) {
  var _useKibana$services$h, _useKibana$services$h2, _activeStep$synthetic, _activeStep$synthetic2;
  const exploratoryView = (0, _public2.useKibana)().services.exploratoryView;
  const EmbeddableExpView = exploratoryView.ExploratoryViewEmbeddable;
  const basePath = (_useKibana$services$h = (0, _public2.useKibana)().services.http) === null || _useKibana$services$h === void 0 ? void 0 : (_useKibana$services$h2 = _useKibana$services$h.basePath) === null || _useKibana$services$h2 === void 0 ? void 0 : _useKibana$services$h2.get();
  const allSeries = [{
    name: `${title}(${(_activeStep$synthetic = activeStep.synthetics.step) === null || _activeStep$synthetic === void 0 ? void 0 : _activeStep$synthetic.name})`,
    selectedMetricField: field,
    time: getLast48Intervals(activeStep),
    seriesType: 'area',
    dataType: 'synthetics',
    reportDefinitions: {
      'monitor.name': [activeStep.monitor.name],
      'synthetics.step.name.keyword': [(_activeStep$synthetic2 = activeStep.synthetics.step) === null || _activeStep$synthetic2 === void 0 ? void 0 : _activeStep$synthetic2.name]
    },
    operationType: 'last_value'
  }];
  const href = (0, _public.createExploratoryViewUrl)({
    reportType: 'kpi-over-time',
    allSeries
  }, basePath);
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(EmbeddableExpView, {
    title: title,
    appendTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsStepFieldTrendButton",
      iconType: 'visArea',
      href: href,
      target: "_blank",
      size: "s"
    }, EXPLORE_LABEL),
    reportType: 'kpi-over-time',
    attributes: allSeries,
    axisTitlesVisibility: {
      x: false,
      yLeft: false,
      yRight: false
    },
    legendIsVisible: false,
    dataTypesIndexPatterns: {
      synthetics: _constants.SYNTHETICS_INDEX_PATTERN
    },
    withActions: false
  }));
}
const EXPLORE_LABEL = exports.EXPLORE_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.markers.explore', {
  defaultMessage: 'Explore'
});
const Wrapper = _common.euiStyled.div`
  height: 200px;
  width: 400px;
  &&& {
    .expExpressionRenderer__expression {
      padding-bottom: 0 !important;
    }
  }
`;