"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JourneyStepScreenshotContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
var _journey_screenshot_dialog = require("./journey_screenshot_dialog");
var _contexts = require("../../../contexts");
var _use_retrieve_step_image = require("../monitor_test_result/use_retrieve_step_image");
var _journey_screenshot_preview = require("../monitor_test_result/journey_screenshot_preview");
var _screenshot_size = require("./screenshot_size");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JourneyStepScreenshotContainer = ({
  allStepsLoaded,
  timestamp,
  checkGroup,
  stepStatus,
  initialStepNumber = 1,
  retryFetchOnRevisit = false,
  testNowMode,
  size = _screenshot_size.THUMBNAIL_SCREENSHOT_SIZE,
  unavailableMessage,
  borderRadius
}) => {
  var _imageResult$imgPath;
  const intersectionRef = _react.default.useRef(null);
  const {
    basePath
  } = (0, _react.useContext)(_contexts.SyntheticsSettingsContext);
  const imgPath = checkGroup ? (0, _journey_screenshot_dialog.getScreenshotUrl)({
    basePath,
    checkGroup,
    stepNumber: initialStepNumber
  }) : '';
  const intersection = (0, _useIntersection.default)(intersectionRef, {
    root: null,
    rootMargin: '0px',
    threshold: 0.1
  });
  const imageResult = (0, _use_retrieve_step_image.useRetrieveStepImage)({
    hasIntersected: Boolean(intersection && intersection.intersectionRatio > 0),
    stepStatus,
    imgPath,
    retryFetchOnRevisit,
    checkGroup,
    testNowMode,
    timestamp
  });
  const {
    url,
    loading,
    stepName,
    maxSteps
  } = (_imageResult$imgPath = imageResult === null || imageResult === void 0 ? void 0 : imageResult[imgPath]) !== null && _imageResult$imgPath !== void 0 ? _imageResult$imgPath : {};
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: intersectionRef
  }, /*#__PURE__*/_react.default.createElement(_journey_screenshot_preview.JourneyScreenshotPreview, {
    checkGroup: checkGroup,
    stepName: stepName,
    imgSrc: url,
    stepNumber: initialStepNumber,
    isStepFailed: stepStatus === 'failed',
    maxSteps: maxSteps,
    isLoading: Boolean(loading || !allStepsLoaded),
    size: size,
    unavailableMessage: unavailableMessage,
    borderRadius: borderRadius,
    timestamp: timestamp
  }));
};
exports.JourneyStepScreenshotContainer = JourneyStepScreenshotContainer;