"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JourneyScreenshotPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _screenshot_size = require("../screenshot/screenshot_size");
var _journey_screenshot_dialog = require("../screenshot/journey_screenshot_dialog");
var _screenshot_image = require("../screenshot/screenshot_image");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JourneyScreenshotPreview = ({
  timestamp,
  checkGroup,
  stepName,
  stepNumber,
  imgSrc,
  maxSteps,
  isStepFailed,
  isLoading,
  size,
  unavailableMessage,
  borderRadius
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isImagePopoverOpen, setIsImagePopoverOpen] = (0, _react.useState)(false);
  const [isImageDialogOpen, setIsImageDialogOpen] = (0, _react.useState)(false);

  // Only render the dialog if the image is at least once clicked
  const [isImageEverClick, setIsImageEverClicked] = (0, _react.useState)(false);
  const onImgFocus = (0, _react.useCallback)(_evt => {
    setIsImagePopoverOpen(true);
  }, [setIsImagePopoverOpen]);
  const onImgBlur = (0, _react.useCallback)(_evt => {
    setIsImagePopoverOpen(false);
  }, [setIsImagePopoverOpen]);
  const onImgClick = (0, _react.useCallback)(evt => {
    evt.stopPropagation();
    setIsImageEverClicked(true);
    setIsImageDialogOpen(true);
    setIsImagePopoverOpen(false);
  }, [setIsImagePopoverOpen]);
  const onDialogClose = (0, _react.useCallback)(() => {
    setIsImageDialogOpen(false);
  }, [setIsImageDialogOpen]);
  const renderScreenshotImage = screenshotSize => /*#__PURE__*/_react.default.createElement(_screenshot_image.ScreenshotImage, {
    label: _i18n.i18n.translate('xpack.synthetics.monitorTestResult.screenshotImageLabel', {
      defaultMessage: '"{stepName}", {stepNumber} of {totalSteps}',
      values: {
        stepName,
        stepNumber,
        totalSteps: maxSteps !== null && maxSteps !== void 0 ? maxSteps : stepNumber
      }
    }),
    imgSrc: imgSrc,
    isLoading: isLoading,
    size: screenshotSize,
    unavailableMessage: unavailableMessage,
    borderColor: isStepFailed ? euiTheme.colors.danger : undefined,
    borderRadius: borderRadius,
    onFocus: onImgFocus,
    onBlur: onImgBlur,
    onClick: onImgClick
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isImageEverClick ? /*#__PURE__*/_react.default.createElement(_journey_screenshot_dialog.JourneyScreenshotDialog, {
    checkGroup: checkGroup,
    initialImgSrc: imgSrc,
    initialStepNumber: stepNumber,
    maxSteps: maxSteps,
    isOpen: isImageDialogOpen,
    onClose: onDialogClose,
    timestamp: timestamp
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "leftDown",
    button: renderScreenshotImage(size),
    isOpen: isImagePopoverOpen
  }, renderScreenshotImage(_screenshot_size.POPOVER_SCREENSHOT_SIZE)));
};
exports.JourneyScreenshotPreview = JourneyScreenshotPreview;