"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeltaPercent = exports.ThresholdIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeltaPercent = (current, previous) => {
  if (previous === 0 || previous === null || previous === undefined) {
    return 0;
  }
  return Number(((current - previous) / previous * 100).toFixed(0));
};
exports.getDeltaPercent = getDeltaPercent;
const ThresholdIndicator = ({
  description,
  helpText,
  loading,
  current,
  previous,
  previousFormatted,
  currentFormatted,
  asStat = false
}) => {
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    });
  }
  const delta = getDeltaPercent(current, previous);
  const getToolTipContent = () => {
    return _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip', {
      defaultMessage: 'Value is {deltaLabel} compared to previous steps in last 24 hours.',
      values: {
        deltaLabel: Math.abs(delta) === 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip.noChange', {
          defaultMessage: 'same'
        }) : delta > 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.increased', {
          defaultMessage: '{delta}% higher',
          values: {
            delta
          }
        }) : _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.decreased', {
          defaultMessage: '{delta}% lower',
          values: {
            delta: Math.abs(delta)
          }
        })
      }
    });
  };
  const getColor = () => {
    if (Math.abs(delta) < 5) {
      return 'default';
    }
    return delta > 5 ? 'danger' : 'success';
  };
  const hasDelta = Math.abs(delta) > 0;
  const content = previous === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minus",
    size: asStat ? 'l' : 'm',
    color: "subdued"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: getToolTipContent(),
    title: _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.previous', {
      defaultMessage: 'Median(24h): {previous}',
      values: {
        previous: previousFormatted
      }
    })
  }, hasDelta ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: delta > 0 ? 'sortUp' : 'sortDown',
    size: asStat ? 'l' : 'm',
    color: getColor()
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minus",
    size: asStat ? 'l' : 'm',
    color: "subdued"
  }));
  if (asStat) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
      titleSize: "s",
      titleColor: getColor(),
      description: /*#__PURE__*/_react.default.createElement("span", null, description, " ", helpText && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: helpText,
        position: "right"
      })),
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentFormatted, /*#__PURE__*/_react.default.createElement("span", {
        style: {
          marginLeft: 5
        }
      }, content)),
      reverse: true
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: getColor()
  }, /*#__PURE__*/_react.default.createElement("strong", null, currentFormatted))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, content));
};
exports.ThresholdIndicator = ThresholdIndicator;